Imports System
Imports EnvDTE
Imports Microsoft.VisualBasic

Namespace ToolboxSnippetsInstaller
	''' <summary>
	''' Summary description for ToolboxInstaller.
	''' </summary>
	Public Class ToolboxInstaller
		Public Sub New()
			'
			' TODO: Add constructor logic here
			'
		End Sub

		''' <summary>
        ''' Metoda aduje dowoln liczb fragmentw kodu do okienka narzdziowego
		''' </summary>
		Public Shared Sub LoadSnippets()
            ' Zarejestrowanie filtra komunikatw OLE, by unikn wyjtkw "call rejected"
			MessageFilter.Register()

            ' Pobranie odwoania do obiektu DTE
            Dim latestDTE As Type = Type.GetTypeFromProgID("VisualStudio.DTE.7.1")
            Dim env As EnvDTE.DTE = CType(Activator.CreateInstance(latestDTE), EnvDTE.DTE)

            ' Pobranie okna narzdziowego Toolbox
            Dim win As Window = env.Windows.Item(EnvDTE.Constants.vsWindowKindToolbox)

            ' Pobranie okna narzdziowego
			Dim toolBox As ToolBox = CType(win.Object, ToolBox)

			Dim tab As ToolBoxTab = Nothing

            ' Przejcie przez kolekcj zakadek i sprawdzenie, czy odpowiednia zakadka ju istnieje
			For Each tb As ToolBoxTab In toolBox.ToolBoxTabs
                If tb.Name = "Nasze kontrolki" Then
                    tab = tb
                End If
            Next tb

            ' Zakadka nie istnieje, wic trzeba j doda
			If tab Is Nothing Then
                tab = toolBox.ToolBoxTabs.Add("Nasze kontrolki")
			End If

            ' Wywietlenie okna waciwoci, by ustrzec si bdw
			env.ExecuteCommand("View.PropertiesWindow","")

            ' Uaktywnienie zakadki (poniewa metoda Add dodaje kontrolki tylko do aktywnej zakadki)		
			tab.Activate()

            ' Wybranie pierwszej pozycji (jest to jedyny sposb, by wszystko poszo dobrze)
			tab.ToolBoxItems.Item(1).Select()

            ' Dodanie do okna narzdziowego nowych pozycji - wasnych kontrolek
			Dim tbi1 As ToolBoxItem = tab.ToolBoxItems.Add("not used", "C:\windows\Microsoft.NET\Framework\v1.1.4322\System.Web.dll", vsToolBoxItemFormat.vsToolBoxItemFormatDotNETComponent)

            ' Zamknicie rodowiska
			env.Quit()
            ' Odczenie filtra komunikatw
			MessageFilter.Revoke()

		End Sub
	End Class
End Namespace
